	subroutine SOLVE(iout, idbg, Nn, Nb, Np, Ns, NnNd, ldw, &
			Kappa, theta, theta1, ipar, fpar, ipar0, fpar0, &
			BCe, BCvalue, BCtype, C, T, Cold, Told, Rn, &
			vA, vL, vB, rA, rL, rB, cA, cL, cB, lastA, lastL, lastB, &
			In, Kn, Ao, gm0, gm1, m1s, phi, phio, &
			Iyn, Kyn, w, work, &
			Nr, order, Rr)		! ### new parameters ###
! solve equations and update

	implicit none
	integer iout, idbg
	integer Nn, Nb, Np, Ns, Npsi, NnNd	! array parameters
	integer lastA, lastL, lastB
	integer ldw
	real*8 Kappa
	integer ipar(16), ipar0(16)		! bCGstab integer parameters array
	real*8 fpar(16), fpar0(16)		! bCGstab real    parameters array
	real*8  theta, theta1
	integer rA (Nn+1), rL (Nn+1), rB(Nn+1)	! global  arrays (compact rows)
	integer cA (NnNd), cL (NnNd), cB(NnNd)	! global  arrays (compact columns)
	integer BCe(Nb,3)			! BC element numbers
	real*8 BCvalue(Nb,Ns,2)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('R', 'N' or 'D')
	real*8 C   (Nn,Ns), T   (Nn,Ns)		! global  arrays
	real*8 Cold(Nn,Ns), Told(Nn,Ns) 	! global  arrays
	real*8 phi(Nn), phio(Nn)		! global  arrays
	real*8 Rn(Nn,Ns), w(Nn,Ns), work(ldw)	! work arrays
	real*8 vA (NnNd ), vL (NnNd ), vB(NnNd)	! global  arrays (compact values)
	real*8 In(Nn,Ns,0:Np), Kn(Nn,Ns,Np)	! convolution arrays for M*C
	real*8 Iyn(Nn,0:Np), Kyn(Nn,Np	)	! convolution arrays for M*phi
	real*8 gm0(Nn,Np), gm1(Nn,Np), m1s(Nn,Np), Ao(Nn)  	! nodal averaged arrays

	integer Nr				! ### new parameters ###
	integer order(Nn,0:1)			! ### new parameters ###
	real*8 Rr(Nn,Ns)			! ### new parameters ###

	integer i, n, p, s

!	write(idbg,'(a)') ' --- SOLVE ---'	! ### TEMPORARY ###

! solve A dC/dt + B*I + T = 0

! A is alpha
! L is beta
! Cold and Told are C(n  ) and T(n ), respectively, where n is time step number
! C    and T    are C(n+1) and Tn+1), respectively, on exit

! calculate Rn+1 (the RHS at n+1) and store in Rn
! Rn+1 = beta*Cn - { theta*Tn+1 + (1-theta)*Tn }
!	 - B * sum on p#0 of { [ theta1 +  theta*Mp(dt)/Ap ] * Inp }
	Rn = theta*T + theta1*Told	! use matrix form (implicit)

! compute {Rn} = [L]{Cold} - {Rn} using AMUX from SPARSKIT2
	do s = 1, Ns
	  call AMUX(Nn, Cold(1,s), w(1,s), vL, cL, rL)	! {w} = [L]{Cold}
	enddo		! s
	Rn = w - Rn

! for EXP only: add the other terms
	if(Np .ne. 0)	then
! calculate w, the term in the [...] in the Rn comment above
	  w = 0.d0	! use matrix form
	  do i = 1, Nn
	    do p = 1, Np
	      do s = 1, Ns
	        w(i,s) = w(i,s) + ( theta1 + theta*m1s(i,p) ) * In(i,s,p)
	      enddo	! s
	    enddo	! p
	  enddo		! i

! compute {Rn} = -[B]{w} + {Rn} using AMUX from SPARSKIT2
	  do s = 1, Ns
	    call AMUX(Nn, w(1,s), work, vB, cB, rB)	! {work} = [B]{w}
            do i = 1, Nn
              Rn(i,s) = Rn(i,s) - work (i)
	    enddo	! i
 	  enddo		! s
	endif

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! NEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! modify Rn if Dirichlet BC
! order Rn
! permute Rn vector (in-place)
	do s = 1, Ns
	  call DVPERM (Nn, Rn(:,s), order(:,1)) 
	enddo	! s
! subtract Rr
	Rn = Rn - Rr
! permute C vector (in-place)
	do s = 1, Ns
	  call DVPERM (Nn, C (:,s), order(:,1)) 
	enddo	! s
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! NEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! solve {[alpha]{Cn+1} = {Rn+1} using bCGstab
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	do s = 1, Ns
	  ipar = ipar0	! restore the original ipar
	  fpar = fpar0	! restore the original fpar

10	  call bCGstab(Nr, Rn(1,s), C(1,s), ipar, fpar , work)
	  if (ipar(1) .eq. 1) then
	    call AMUX(Nr, work(ipar(8)), work(ipar(9)), vA, cA, rA)
	    go to 10
	  else if(ipar(1) .ne. 0)	then
	    write(idbg,'(a)') ' --- SOLVE ---'	! ### TEMPORARY ###
	    write(idbg,*) 'ipar = ', ipar
	    write(idbg,*) 'fpar = ', fpar
	    stop 'problem in bCGstab'
	  endif
	enddo	! s
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! NEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! permute C vector (in-place) back to the original order
	do s = 1, Ns
	  call DVPERM (Nn, C (:,s), order(:,0)) 
	enddo	! s
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! NEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! force non-negative C
	  do i = 1, Nn
	    do s = 1, Ns
	      if(C(i,s) .lt. 0.)	C(i,s) = 0.
	    enddo		! s
	  enddo			! i

	if(Np .eq. 0)	then
! for ADE only
	  if(Kappa .ne. 0) then
	    do i = 1, Nn
	      phi(i) = C(i,1)*C(i,2)	! store Ca*Cb in phi
	    enddo		! i
	  endif

	else
! for EXP only
	  do i = 1, Nn
	    do s = 1, Ns
	      do p = 0, Np
	        if(p .eq. 0) then
! update    In+1 (the convolution of Mp*C of term p=0 from step 0 to step n+1)
		  In(i,s,p) = Ao(i) * C(i,s)	! for p=0, In=Kn
	        else
! calculate Kn+1 (the convolution of Mp*C of term p>0 from step n to step n+1)
! update    In+1 (the convolution of Mp*C of term p>0 from step 0 to step n+1)
		  Kn(i,s,p) = gm0(i,p)*Cold(i,s) +  gm1(i,p)*C(i,s)
		  In(i,s,p) = Kn(i,s,p) + In(i,s,p) * m1s(i,p)
		endif
	      enddo		! p
	    enddo		! s
	  enddo			! i

	  if(Kappa .ne. 0)	then
! update phi^(n+1) = (Ca*Cb)^(n+1)
	    do i = 1, Nn
	      phi(i) = C(i,1)*C(i,2)	! store Ca*Cb in phi
	    enddo		! i
! for EXP reactive only
! update Iyn, Kyn for the convolution M*phi
	    do i = 1, Nn
	      do p = 0, Np
	        if(p .eq. 0) then
! update    Iyn+1 (the convolution of Mp*phi of term p=0 from step 0 to step n+1)
		  Iyn(i,p) = Ao(i) * phi(i)	! for p=0, Iyn=Kyn
	        else
! calculate Kyn+1 (the convolution of Mp*phi of term p>0 from step n to step n+1)
! update    Iyn+1 (the convolution of Mp*phi of term p>0 from step 0 to step n+1)
		  Kyn(i,p) = gm0(i,p)*phio(i) +  gm1(i,p)*phi(i)
		  Iyn(i,p) = Kyn(i,p) + Iyn(i,p) * m1s(i,p)
		endif
	      enddo		! p
	    enddo		! i
	  endif
	endif

	return
	end
